DROP PROCEDURE [hips].[HospitalPatientUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 15 October 2012
-- Description:   Inserts a new record into the Patient Table
-- =============================================
CREATE PROCEDURE [hips].[HospitalPatientUpdate]
(
		@PatientId INT,
      @PatientMasterId INT
      ,@HospitalId INT
      ,@Mrn VARCHAR(20)
	  ,@UserModified varchar(256)
	  ,@DateModified DATETIME
)
AS
BEGIN
    SET NOCOUNT ON
    DECLARE @intErrorCode INT
		
    SET @intErrorCode = 0
    IF NOT EXISTS (SELECT TOP 1 [DateModified]
                FROM [hips].[HospitalPatient]
        WHERE [PatientId] = @PatientId
        AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
    IF @intErrorCode = 0
    BEGIN
    UPDATE hips.HospitalPatient
		SET PatientMasterId = @PatientMasterId,
			HospitalId = @HospitalId,
			Mrn = @Mrn,
			DateModified = @DateModified,
			UserModified = @UserModified
		WHERE
			PatientId = @PatientId
			
   
    SELECT @intErrorCode = @@ERROR 
    END
    IF @intErrorCode = 0
    BEGIN
        SELECT 
           PatientId,
           PatientMasterId,
           HospitalId,
           Mrn,
           DateCreated,
           UserCreated,
           DateModified,
           UserModified
         FROM [hips].[HospitalPatient]
         WHERE [PatientId] = @PatientId
    END
    RETURN(@intErrorCode)
END
GO

